<!DOCTYPE html>
<html>
<head>
  <title>PC1</title>
  <style>
  .kotak1 {
    position: absolute;
    width: 50px;
    height: 50px;
    border-radius: 8px;
    transition: all 0.2s linear;
  }
  .kotak2 {
    position: absolute;
    width: 50px;
    height: 50px;
    border-radius: 8px;
    transition: all 0.2s linear;
  }
  #merah { background: red; }
  #biru { background: blue; }
  #info { position: fixed; bottom: 10px; left: 10px; font-family: sans-serif; }

  @keyframes kelapKelip {
0% { filter: drop-shadow(0 0 2px white); }
50% { filter: drop-shadow(0 0 10px yellow); }
100% { filter: drop-shadow(0 0 2px white); }
}
.kelap {
animation: kelapKelip 0.6s infinite;
}

@keyframes apiSerang {
0%   { box-shadow: 0 0 10px red; }
50%  { box-shadow: 0 0 20px orange; }
100% { box-shadow: 0 0 10px red; }
}
.serang-api {
animation: apiSerang 0.3s ease-out;
}

@keyframes gerakLiar {
0%   { transform: translate(0, 0) rotate(0deg); }
25%  { transform: translate(-10px, 5px) rotate(10deg); }
50%  { transform: translate(10px, -5px) rotate(-10deg); }
75%  { transform: translate(-5px, 10px) rotate(5deg); }
100% { transform: translate(0, 0) rotate(0deg); }
}
.liar {
animation: gerakLiar 0.4s ease-in-out;
}
</style>

</head>
<body>
  <img id="pc1" src="pic/pc1.png" class="kotak1">
  <img id="pc2" src="pic/pc2.png" class="kotak2">
  <img id="pc3" src="pic/pc2.png" class="kotak2">
  <img id="pc4" src="pic/pc2.png" class="kotak2">

  <div id="info"></div>

  <audio id="langkah" src="sound/langkah.mp3" preload="auto" loop></audio>
  <audio id="bgmusic" src="sound/bgmusic.mp3" preload="auto" loop></audio>
  <audio id="serang" src="sound/serang.mp3" preload="auto"></audio>

  <script>
    const pc1 = document.getElementById("pc1");
    const info = document.getElementById("info");
    let pospc1 = { x: 0, y: 0 };
    let lastX = 0;
    let aktifGerak = false;
    let gerakTimer = null;

    fetch("get.php")
      .then(res => res.json())
      .then(data => {
        if (data.pc1) {
          pospc1 = data.pc1;
          lastX = pospc1.x;
          pc1.style.left = pospc1.x + "px";
          pc1.style.top = pospc1.y + "px";
        }
      });

      pc1.onclick = () => {
        aktifGerak = !aktifGerak;
        info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";

        if (aktifGerak) {
          pc1.classList.remove("kelap", "liar"); // bersihkan dulu
          void pc1.offsetWidth; // paksa reflow
          pc1.classList.add("kelap");
          langkah.currentTime = 0;
          langkah.play();
        } else {
          pc1.classList.remove("kelap", "liar");
          langkah.pause();
        }
      };

  document.body.onmousemove = (e) => {
  if (!aktifGerak || e.target.id === "pc3") return;

  const x = e.clientX - 25;
  const y = e.clientY - 25;
  let arah = "";

  if (x > lastX) {
    pc1.style.transform = "scaleX(1)";
    arah = "kanan";
  } else if (x < lastX) {
    pc1.style.transform = "scaleX(-1)";
    arah = "kiri";
  }

  lastX = x;
  pospc1 = { x, y };
  pc1.style.left = x + "px";
  pc1.style.top = y + "px";

  fetch("update.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `id=pc1&x=${x}&y=${y}&arah=${arah}`
  });
};


function ambilPosisi() {
fetch("get.php")
.then(res => res.json())
.then(data => {
  // ✅ Terapkan posisi dan arah pc1 dari database
  if (data.pc1) {
    pospc1 = { x: data.pc1.x, y: data.pc1.y };
    pc1.style.left = data.pc1.x + "px";
    pc1.style.top = data.pc1.y + "px";

    if (data.pc1.arah === "kanan") {
      pc1.style.transform = "scaleX(1)";
    } else if (data.pc1.arah === "kiri") {
      pc1.style.transform = "scaleX(-1)";
    }
  }

  // ✅ Proses lawan (pc2, pc3, dst)
  let tabrak = false;
  for (const id in data) {
    if (id === "pc1") continue;
    const elemen = document.getElementById(id);
    if (!elemen) continue;

    elemen.style.left = data[id].x + "px";
    elemen.style.top = data[id].y + "px";

    if (data[id].arah === "kanan") elemen.style.transform = "scaleX(1)";
    else if (data[id].arah === "kiri") elemen.style.transform = "scaleX(-1)";

    if (Math.abs(pospc1.x - data[id].x) < 50 && Math.abs(pospc1.y - data[id].y) < 50) {
      info.innerText = `💥 Tabrakan dengan ${id.toUpperCase()}!`;
      tabrak = true;
      break;
    }
  }

  if (!tabrak) {
    info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";
  }
});
}


document.addEventListener("keydown", (e) => {
if (e.key.toLowerCase() === "a") {
  pc1.classList.remove("liar", "kelap"); // hapus dulu semua
  void pc1.offsetWidth; // paksa reflow
  pc1.classList.add("liar", "kelap"); // tambahkan ulang

  serang.currentTime = 0;
  serang.play();
}
});

    setInterval(ambilPosisi, 300);

    window.addEventListener("load", () => {
      bgmusic.volume = 0.1;
      bgmusic.play().catch(() => {
        document.body.addEventListener("click", () => {
          bgmusic.play();
        }, { once: true });
      });
    });
  </script>
</body>
</html>
