<!DOCTYPE html>
<html>
<head>
  <title>PC1</title>
  <style>
    .kotak1 {
      position: absolute;
      width: 50px;
      height: 50px;
      border-radius: 8px;
      transition: all 0.2s linear;
    }
    .kotak2 {
      position: absolute;
      width: 50px;
      height: 50px;
      border-radius: 8px;
      transition: all 0.2s linear;
    }
    #merah { background: red; }
    #biru { background: blue; }
    #info { position: fixed; bottom: 10px; left: 10px; font-family: sans-serif; }

    @keyframes kelapKelip {
  0% { filter: drop-shadow(0 0 2px white); }
  50% { filter: drop-shadow(0 0 10px yellow); }
  100% { filter: drop-shadow(0 0 2px white); }
}
.kelap {
  animation: kelapKelip 0.6s infinite;
}

@keyframes apiSerang {
  0%   { box-shadow: 0 0 10px red; }
  50%  { box-shadow: 0 0 20px orange; }
  100% { box-shadow: 0 0 10px red; }
}
.serang-api {
  animation: apiSerang 0.3s ease-out;
}

@keyframes gerakLiar {
  0%   { transform: translate(0, 0) rotate(0deg); }
  25%  { transform: translate(-10px, 5px) rotate(10deg); }
  50%  { transform: translate(10px, -5px) rotate(-10deg); }
  75%  { transform: translate(-5px, 10px) rotate(5deg); }
  100% { transform: translate(0, 0) rotate(0deg); }
}
.liar {
  animation: gerakLiar 0.4s ease-in-out;
}
</style>
</head>
<body>
  <img id="pc1" src="pic/pc1.png" class="kotak1">
  <img id="pc2" src="pic/pc2.png" class="kotak1">
  <img id="pc3" src="pic/pc2.png" class="kotak1">
  <div id="info"></div>
  <audio id="langkah" src="sound/langkah.mp3" preload="auto" loop></audio>
  <audio id="bgmusic" src="sound/bgmusic.mp3" preload="auto" loop></audio>
  <audio id="serang" src="sound/serang.mp3" preload="auto"></audio>


  <script>
  const pc1 = document.getElementById("pc1");
  const pc2 = document.getElementById("pc2");
  const pc3 = document.getElementById("pc3");
  const info = document.getElementById("info");

  let pos1 = { x: 0, y: 0 };
  let lastX = 0;
  let aktifGerak = false; // toggle gerakan
  let gerakTimer = null;

  const suaraAktif = document.getElementById("suaraAktif");
  const serang = document.getElementById("serang");

  pc1.onclick = () => {
    aktifGerak = !aktifGerak;
    info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";

    if (aktifGerak) {
      pc1.classList.remove("kelap", "liar"); // bersihkan dulu
      void pc1.offsetWidth; // paksa reflow
      pc1.classList.add("kelap");
      langkah.currentTime = 0;
      langkah.play();
    } else {
      pc1.classList.remove("kelap", "liar");
      langkah.pause();
    }
  };


  // Update posisi saat mouse bergerak jika aktifGerak true
  document.body.onmousemove = (e) => {
  if (!aktifGerak || e.target.id !== "pc1") return;
  const x = e.clientX - 25;
  const y = e.clientY - 25;
  if (x > lastX) {
    pc1.style.transform = "scaleX(1)";
    arah = "kanan";
  } else if (x < lastX) {
    pc1.style.transform = "scaleX(-1)";
    arah = "kiri";
  }
  langkah.play();
  clearTimeout(gerakTimer);
  gerakTimer = setTimeout(() => {
    langkah.pause();
    langkah.currentTime = 0;
  }, 500); // berhenti jika tidak gerak selama 500ms
  lastX = x;
  pos1 = { x, y };
  pc1.style.left = x + "px";
  pc1.style.top = y + "px";
  fetch("update.php", {
    method: "POST",
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: `id=pc1&x=${x}&y=${y}&arah=${arah}`
  });
};

  function updatePositionAndDirection(element, pos) {
    element.style.left = pos.x + "px";
    element.style.top = pos.y + "px";
    if (pos.arah === "kanan") {
      element.style.transform = "scaleX(1)";
    } else if (pos.arah === "kiri") {
      element.style.transform = "scaleX(-1)";
    }
    if (pos.aksi === "dodol") {
      element.style.border = "1px solid red";
    } else if (pos.aksi === "xxx") {
      element.style.border = "1px solid green";
    }
  }

  function updateStatusMultiple(pairs, aktifGerak) {
    for (const [posA, posB] of pairs) {
      if (Math.abs(posA.x - posB.x) < 50 && Math.abs(posA.y - posB.y) < 50) {
        info.innerText = "💥 Tabrakan antara " + posA.idx + " dan " + posB.idx;
        serang.currentTime = 0;
        serang.play();
        return;
      }
    }
    info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";
  }

  function ambilPosisi() {
    fetch("get.php")
      .then(res => res.json())
      .then(data => {
        updatePositionAndDirection(pc1, data.pc1);
        updatePositionAndDirection(pc2, data.pc2);
        updatePositionAndDirection(pc3, data.pc3);
        const pairs = [
          [data.pc1, data.pc2],
          [data.pc1, data.pc3]
        ];
        updateStatusMultiple(pairs, aktifGerak);
      });
  }

  document.addEventListener("keydown", (e) => {
  if (e.key.toLowerCase() === "a") {
    pc1.classList.remove("liar", "kelap"); // hapus dulu semua
    void pc1.offsetWidth; // paksa reflow
    pc1.classList.add("liar", "kelap"); // tambahkan ulang
    serang.currentTime = 0;
    serang.play();
    // Kirim status aksi ke server
    fetch("update.php", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: `id=pc1&x=${pos1.x}&y=${pos1.y}&arah=${arah}&aksi=liar`
    });
    // Reset aksi setelah 1 detik agar tidak terus aktif
   setTimeout(() => {
     fetch("update.php", {
       method: "POST",
       headers: { "Content-Type": "application/x-www-form-urlencoded" },
       body: `id=pc1&x=${pos1.x}&y=${pos1.y}&arah=${arah}&aksi=`
     });
   }, 300);
  }
});


  setInterval(ambilPosisi, 300);

  window.addEventListener("load", () => {
    const bgmusic = document.getElementById("bgmusic");
    bgmusic.volume = 0.0
    bgmusic.play().catch(() => {
      // Jika autoplay gagal, tunggu klik pertama
      document.body.addEventListener("click", () => {
        bgmusic.play();
      }, { once: true });
    });
  });
</script>



</body>
</html>
