<!DOCTYPE html>
<html>
<head>
  <title>PC2</title>
  <style>
    .kotak1 {
      position: absolute;
      width: 50px;
      height: 50px;
      border-radius: 8px;
      transition: all 0.2s linear;
    }
    #info {
      position: fixed;
      bottom: 10px;
      left: 10px;
      font-family: sans-serif;
    }

    @keyframes kelapKelip {
      0% { filter: drop-shadow(0 0 2px white); }
      50% { filter: drop-shadow(0 0 10px yellow); }
      100% { filter: drop-shadow(0 0 2px white); }
    }
    .kelap {
      animation: kelapKelip 0.6s infinite;
    }

    @keyframes apiSerang {
      0%   { box-shadow: 0 0 10px red; }
      50%  { box-shadow: 0 0 20px orange; }
      100% { box-shadow: 0 0 10px red; }
    }
    .serang-api {
      animation: apiSerang 0.3s ease-out;
    }

    @keyframes gerakLiar {
      0%   { transform: translate(0, 0) rotate(0deg); }
      25%  { transform: translate(-10px, 5px) rotate(10deg); }
      50%  { transform: translate(10px, -5px) rotate(-10deg); }
      75%  { transform: translate(-5px, 10px) rotate(5deg); }
      100% { transform: translate(0, 0) rotate(0deg); }
    }
    .liar {
      animation: gerakLiar 0.4s ease-in-out;
    }
  </style>
</head>
<body>
  <img id="pc2" src="pic/pc2.png" class="kotak1">
  <img id="pc1" src="pic/pc1.png" class="kotak1">
  <img id="pc3" src="pic/pc2.png" class="kotak1">
  <div id="info"></div>

  <audio id="langkah" src="sound/langkah.mp3" preload="auto" loop></audio>
  <audio id="bgmusic" src="sound/bgmusic.mp3" preload="auto" loop></audio>
  <audio id="serang" src="sound/serang.mp3" preload="auto"></audio>

  <script>
    const pc2 = document.getElementById("pc2");
    const pc1 = document.getElementById("pc1");
    const pc3 = document.getElementById("pc3");
    const info = document.getElementById("info");
    const langkah = document.getElementById("langkah");
    const serang = document.getElementById("serang");

    let aktifGerak = false;
    let lastX = 0;
    let arah = "kanan";
    let gerakTimer = null;

    pc2.onclick = () => {
      aktifGerak = !aktifGerak;
      info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";

      pc2.classList.remove("kelap", "liar");
      void pc2.offsetWidth;
      if (aktifGerak) {
        pc2.classList.add("kelap");
        langkah.currentTime = 0;
        langkah.play();
      } else {
        langkah.pause();
      }
    };

    document.body.onmousemove = (e) => {
      if (!aktifGerak || e.target.id !== "pc2") return;

      const x = e.clientX - 25;
      const y = e.clientY - 25;

      arah = x > lastX ? "kanan" : "kiri";
      pc2.style.transform = arah === "kanan" ? "scaleX(1)" : "scaleX(-1)";
      lastX = x;

      pc2.style.left = x + "px";
      pc2.style.top = y + "px";

      langkah.play();
      clearTimeout(gerakTimer);
      gerakTimer = setTimeout(() => {
        langkah.pause();
        langkah.currentTime = 0;
      }, 500);

      fetch("update.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: `id=pc2&x=${x}&y=${y}&arah=${arah}`
      });
    };

    function updatePositionAndDirection(el, pos) {
      el.style.left = pos.x + "px";
      el.style.top = pos.y + "px";
      el.style.transform = pos.arah === "kiri" ? "scaleX(-1)" : "scaleX(1)";
    }

    function updateStatusMultiple(pairs) {
      for (const [a, b] of pairs) {
        if (Math.abs(a.x - b.x) < 50 && Math.abs(a.y - b.y) < 50) {
          info.innerText = "💥 Tabrakan antara " + a.idx + " dan " + b.idx;
          serang.currentTime = 0;
          serang.play();
          return;
        }
      }
      info.innerText = aktifGerak ? "🟢 Gerak aktif" : "⚪ Gerak nonaktif";
    }

    function ambilPosisi() {
      fetch("get.php")
        .then(res => res.json())
        .then(data => {
          updatePositionAndDirection(pc1, data.pc1);
          updatePositionAndDirection(pc2, data.pc2);
          updatePositionAndDirection(pc3, data.pc3);

          // Reaksi terhadap aksi dari pc1
          if (data.pc1.aksi === "liar") {
          pc1.classList.remove("liar", "kelap");
          void pc1.offsetWidth;
          pc1.classList.add("liar", "kelap");
          serang.currentTime = 0;
          serang.play();
          }


          const pairs = [
            [data.pc2, data.pc1],
            [data.pc2, data.pc3]
          ];
          updateStatusMultiple(pairs);
        });
    }

    document.addEventListener("keydown", (e) => {
      if (e.key.toLowerCase() === "a") {
        pc2.classList.remove("liar", "kelap");
        void pc2.offsetWidth;
        pc2.classList.add("liar", "kelap");
        serang.currentTime = 0;
        serang.play();

        fetch("update.php", {
          method: "POST",
          headers: { "Content-Type": "application/x-www-form-urlencoded" },
          body: `id=pc2&x=${pc2.offsetLeft}&y=${pc2.offsetTop}&arah=${arah}&aksi=liar`
        });
      }
    });

    setInterval(ambilPosisi, 300);

    window.addEventListener("load", () => {
      const bgmusic = document.getElementById("bgmusic");
      bgmusic.volume = 0.0;
      bgmusic.play().catch(() => {
        document.body.addEventListener("click", () => {
          bgmusic.play();
        }, { once: true });
      });
    });
  </script>
</body>
</html>
